/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.documentation.entry;

import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.api.documentation.DocAssets;
import com.hollingsworth.arsnouveau.api.documentation.DocClientUtils;
import com.hollingsworth.arsnouveau.api.documentation.SinglePageCtor;
import com.hollingsworth.arsnouveau.api.documentation.entry.TextEntry;
import com.hollingsworth.arsnouveau.api.documentation.export.DocExporter;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.client.gui.documentation.AugmentIcon;
import com.hollingsworth.arsnouveau.client.gui.documentation.BaseDocScreen;
import com.hollingsworth.nuggets.client.gui.BaseButton;
import com.hollingsworth.nuggets.client.gui.GuiHelpers;
import com.hollingsworth.nuggets.client.gui.NuggetImageButton;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class GlyphEntry
extends TextEntry {
    public AbstractSpellPart spellPart;

    public GlyphEntry(AbstractSpellPart spellPart, BaseDocScreen parent, int x, int y, int width, int height) {
        super(spellPart.getBookDescLang(), (Component)Component.literal((String)spellPart.getLocaleName()), spellPart.glyphItem.getDefaultInstance(), parent, x, y, width, height);
        this.spellPart = spellPart;
    }

    public static SinglePageCtor create(AbstractSpellPart spellPart) {
        return (parent, x, y, width, height) -> new GlyphEntry(spellPart, parent, x, y, width, height);
    }

    @Override
    public int drawTitle(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        Font font = Minecraft.getInstance().font;
        DocClientUtils.blit(guiGraphics, DocAssets.HEADER_WITH_ITEM, this.x, this.y);
        this.setTooltipIfHovered(DocClientUtils.renderItemStack(guiGraphics, this.x + 3, this.y + 3, mouseX, mouseY, this.renderStack));
        GuiHelpers.drawCenteredStringNoShadow((Font)font, (GuiGraphics)guiGraphics, (Component)this.title, (int)(this.x + 70), (int)(this.y + 7), (int)0);
        DocClientUtils.blit(guiGraphics, DocAssets.GLYPH_DETAILS, this.x, this.y + 23);
        return 39;
    }

    @Override
    public List<AbstractWidget> getExtras() {
        List<AbstractWidget> extras = super.getExtras();
        List<SpellSchool> schoolList = this.spellPart.spellSchools;
        SpellSchool firstSchool = schoolList.isEmpty() ? null : schoolList.getFirst();
        DocAssets.BlitInfo schoolImage = firstSchool == null ? DocAssets.NA_ICON : firstSchool.getIcon();
        BaseButton schoolButton = new NuggetImageButton(this.x + 2, this.y + 25, schoolImage.width(), schoolImage.height(), schoolImage.location(), b -> {}).setPlaySound(false);
        if (firstSchool != null) {
            schoolButton.withTooltip(firstSchool.getTextComponent());
        }
        extras.add((AbstractWidget)schoolButton);
        DocAssets.BlitInfo type = this.spellPart.getTypeIcon();
        extras.add((AbstractWidget)new NuggetImageButton(this.x + 15, this.y + 25, type.width(), type.height(), type.location(), b -> {}).setPlaySound(false).withTooltip(this.spellPart.getTypeName()));
        SpellTier tier = this.spellPart.getConfigTier();
        DocAssets.BlitInfo tierAsset = tier.docInfo.get();
        extras.add((AbstractWidget)new NuggetImageButton(this.x + 26, this.y + 25, tierAsset.width(), tierAsset.height(), tierAsset.location(), b -> {}).setPlaySound(false).withTooltip((Component)Component.translatable((String)(tier.id.getNamespace() + ".tier." + tier.id.getPath()))));
        int augmentCount = 0;
        for (AbstractSpellPart abstractSpellPart : this.spellPart.compatibleAugments) {
            extras.add((AbstractWidget)new AugmentIcon(this.spellPart, this.x + 33 + augmentCount * 11, this.y + 22, 10, 10, (Component)Component.empty(), b -> {}, abstractSpellPart.glyphItem.getDefaultInstance(), (Screen)this.parent).withScale(10).setPlaySound(false));
            ++augmentCount;
        }
        return extras;
    }

    @Override
    public void addExportProperties(JsonObject object) {
        super.addExportProperties(object);
        if (this.spellPart != null) {
            object.addProperty(DocExporter.TIER_PROPERTY, (Number)this.spellPart.getConfigTier().value);
        }
    }
}

